package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTransitGatewayRouteTableAttachmentRequest(
    attachmentId: AttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest = {
    import GetTransitGatewayRouteTableAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayRouteTableAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest =
      zio.aws.networkmanager.model
        .GetTransitGatewayRouteTableAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
  ) extends zio.aws.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
  ): zio.aws.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
