package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{Integer, CoreNetworkId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCoreNetworkPolicyRequest(
    coreNetworkId: CoreNetworkId,
    policyVersionId: Optional[Integer] = Optional.Absent,
    alias: Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest = {
    import GetCoreNetworkPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .optionallyWith(policyVersionId.map(value => value: java.lang.Integer))(
        _.policyVersionId
      )
      .optionallyWith(alias.map(value => value.unwrap))(_.alias)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest
      .wrap(buildAwsValue())
}
object GetCoreNetworkPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest =
      zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest(
        coreNetworkId,
        policyVersionId.map(value => value),
        alias.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def policyVersionId: Optional[Integer]
    def alias: Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyVersionId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicyAlias
    ] = AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest
  ) extends zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyVersionId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.policyVersionId())
      .map(value => value: Integer)
    override val alias
        : Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.networkmanager.model.CoreNetworkPolicyAlias.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest
  ): zio.aws.networkmanager.model.GetCoreNetworkPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
