package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  DateTime,
  AttachmentId,
  ExternalRegionCode,
  ConnectPeerId,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConnectPeer(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    connectAttachmentId: Optional[AttachmentId] = Optional.Absent,
    connectPeerId: Optional[ConnectPeerId] = Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.ConnectPeerState] =
      Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    configuration: Optional[
      zio.aws.networkmanager.model.ConnectPeerConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeer = {
    import ConnectPeer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeer
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        connectAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.connectAttachmentId)
      .optionallyWith(
        connectPeerId.map(value =>
          ConnectPeerId.unwrap(value): java.lang.String
        )
      )(_.connectPeerId)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectPeer.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeer.wrap(buildAwsValue())
}
object ConnectPeer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeer =
      zio.aws.networkmanager.model.ConnectPeer(
        coreNetworkId.map(value => value),
        connectAttachmentId.map(value => value),
        connectPeerId.map(value => value),
        edgeLocation.map(value => value),
        state.map(value => value),
        createdAt.map(value => value),
        configuration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def connectAttachmentId: Optional[AttachmentId]
    def connectPeerId: Optional[ConnectPeerId]
    def edgeLocation: Optional[ExternalRegionCode]
    def state: Optional[zio.aws.networkmanager.model.ConnectPeerState]
    def createdAt: Optional[DateTime]
    def configuration: Optional[
      zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly
    ]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getConnectAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("connectAttachmentId", connectAttachmentId)
    def getConnectPeerId: ZIO[Any, AwsError, ConnectPeerId] =
      AwsError.unwrapOptionField("connectPeerId", connectPeerId)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ConnectPeerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeer
  ) extends zio.aws.networkmanager.model.ConnectPeer.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val connectAttachmentId: Optional[AttachmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectAttachmentId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.AttachmentId(value)
        )
    override val connectPeerId: Optional[ConnectPeerId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectPeerId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConnectPeerId(value)
      )
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val state
        : Optional[zio.aws.networkmanager.model.ConnectPeerState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.ConnectPeerState.wrap(value))
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val configuration: Optional[
      zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.networkmanager.model.ConnectPeerConfiguration.wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeer
  ): zio.aws.networkmanager.model.ConnectPeer.ReadOnly = new Wrapper(impl)
}
