package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLinksResponse(
    links: Optional[Iterable[zio.aws.networkmanager.model.Link]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetLinksResponse = {
    import GetLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
      .builder()
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetLinksResponse.ReadOnly =
    zio.aws.networkmanager.model.GetLinksResponse.wrap(buildAwsValue())
}
object GetLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetLinksResponse =
      zio.aws.networkmanager.model.GetLinksResponse(
        links.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def links: Optional[List[zio.aws.networkmanager.model.Link.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLinks
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Link.ReadOnly]] =
      AwsError.unwrapOptionField("links", links)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ) extends zio.aws.networkmanager.model.GetLinksResponse.ReadOnly {
    override val links
        : Optional[List[zio.aws.networkmanager.model.Link.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.links())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Link.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ): zio.aws.networkmanager.model.GetLinksResponse.ReadOnly = new Wrapper(impl)
}
