package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetConnectPeerAssociationsResponse(
    connectPeerAssociations: Optional[
      Iterable[zio.aws.networkmanager.model.ConnectPeerAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse = {
    import GetConnectPeerAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse
      .builder()
      .optionallyWith(
        connectPeerAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectPeerAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse
      .wrap(buildAwsValue())
}
object GetConnectPeerAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse =
      zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse(
        connectPeerAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectPeerAssociations: Optional[
      List[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getConnectPeerAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectPeerAssociations",
      connectPeerAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly {
    override val connectPeerAssociations: Optional[
      List[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectPeerAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.ConnectPeerAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse
  ): zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
