package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RouteAnalysisPath(
    completionStatus: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletion
    ] = Optional.Absent,
    path: Optional[Iterable[zio.aws.networkmanager.model.PathComponent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath = {
    import RouteAnalysisPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
      .builder()
      .optionallyWith(completionStatus.map(value => value.buildAwsValue()))(
        _.completionStatus
      )
      .optionallyWith(
        path.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisPath.wrap(buildAwsValue())
}
object RouteAnalysisPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisPath =
      zio.aws.networkmanager.model.RouteAnalysisPath(
        completionStatus.map(value => value.asEditable),
        path.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def completionStatus: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly
    ]
    def path
        : Optional[List[zio.aws.networkmanager.model.PathComponent.ReadOnly]]
    def getCompletionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly
    ] = AwsError.unwrapOptionField("completionStatus", completionStatus)
    def getPath: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.PathComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ) extends zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly {
    override val completionStatus: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionStatus())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletion.wrap(value)
      )
    override val path
        : Optional[List[zio.aws.networkmanager.model.PathComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.path())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.PathComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ): zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly = new Wrapper(impl)
}
