package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ExternalRegionCode,
  ConstrainedString,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CoreNetworkSegmentEdgeIdentifier(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    segmentName: Optional[ConstrainedString] = Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier = {
    import CoreNetworkSegmentEdgeIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
      .wrap(buildAwsValue())
}
object CoreNetworkSegmentEdgeIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier =
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier(
        coreNetworkId.map(value => value),
        segmentName.map(value => value),
        edgeLocation.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def segmentName: Optional[ConstrainedString]
    def edgeLocation: Optional[ExternalRegionCode]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
  ) extends zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val segmentName: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentName())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
  ): zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly =
    new Wrapper(impl)
}
