package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ExternalRegionCode,
  ConstrainedString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CoreNetworkSegment(
    name: Optional[ConstrainedString] = Optional.Absent,
    edgeLocations: Optional[Iterable[ExternalRegionCode]] = Optional.Absent,
    sharedSegments: Optional[Iterable[ConstrainedString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment = {
    import CoreNetworkSegment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment
      .builder()
      .optionallyWith(
        name.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        edgeLocations.map(value =>
          value.map { item =>
            ExternalRegionCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.edgeLocations)
      .optionallyWith(
        sharedSegments.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sharedSegments)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkSegment.wrap(buildAwsValue())
}
object CoreNetworkSegment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkSegment =
      zio.aws.networkmanager.model.CoreNetworkSegment(
        name.map(value => value),
        edgeLocations.map(value => value),
        sharedSegments.map(value => value)
      )
    def name: Optional[ConstrainedString]
    def edgeLocations: Optional[List[ExternalRegionCode]]
    def sharedSegments: Optional[List[ConstrainedString]]
    def getName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("name", name)
    def getEdgeLocations: ZIO[Any, AwsError, List[ExternalRegionCode]] =
      AwsError.unwrapOptionField("edgeLocations", edgeLocations)
    def getSharedSegments: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("sharedSegments", sharedSegments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment
  ) extends zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly {
    override val name: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val edgeLocations: Optional[List[ExternalRegionCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ExternalRegionCode(item)
          }.toList
        )
    override val sharedSegments: Optional[List[ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedSegments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConstrainedString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment
  ): zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly = new Wrapper(
    impl
  )
}
