package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionType {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.ConnectionType
}
object ConnectionType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ConnectionType
  ): zio.aws.networkmanager.model.ConnectionType = value match {
    case software.amazon.awssdk.services.networkmanager.model.ConnectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionType.BGP =>
      val r = BGP
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionType.IPSEC =>
      val r = IPSEC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionType =
      software.amazon.awssdk.services.networkmanager.model.ConnectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BGP extends zio.aws.networkmanager.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionType =
      software.amazon.awssdk.services.networkmanager.model.ConnectionType.BGP
  }
  case object IPSEC extends zio.aws.networkmanager.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionType =
      software.amazon.awssdk.services.networkmanager.model.ConnectionType.IPSEC
  }
}
