package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.IPAddress
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectPeerBgpConfiguration(
    coreNetworkAsn: Optional[Long] = Optional.Absent,
    peerAsn: Optional[Long] = Optional.Absent,
    coreNetworkAddress: Optional[IPAddress] = Optional.Absent,
    peerAddress: Optional[IPAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration = {
    import ConnectPeerBgpConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
      .builder()
      .optionallyWith(coreNetworkAsn.map(value => value: java.lang.Long))(
        _.coreNetworkAsn
      )
      .optionallyWith(peerAsn.map(value => value: java.lang.Long))(_.peerAsn)
      .optionallyWith(
        coreNetworkAddress.map(value =>
          IPAddress.unwrap(value): java.lang.String
        )
      )(_.coreNetworkAddress)
      .optionallyWith(
        peerAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.peerAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeerBgpConfiguration
      .wrap(buildAwsValue())
}
object ConnectPeerBgpConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeerBgpConfiguration =
      zio.aws.networkmanager.model.ConnectPeerBgpConfiguration(
        coreNetworkAsn.map(value => value),
        peerAsn.map(value => value),
        coreNetworkAddress.map(value => value),
        peerAddress.map(value => value)
      )
    def coreNetworkAsn: Optional[Long]
    def peerAsn: Optional[Long]
    def coreNetworkAddress: Optional[IPAddress]
    def peerAddress: Optional[IPAddress]
    def getCoreNetworkAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("coreNetworkAsn", coreNetworkAsn)
    def getPeerAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("peerAsn", peerAsn)
    def getCoreNetworkAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("coreNetworkAddress", coreNetworkAddress)
    def getPeerAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ) extends zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly {
    override val coreNetworkAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkAsn())
      .map(value => value: Long)
    override val peerAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAsn())
      .map(value => value: Long)
    override val coreNetworkAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
    override val peerAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ): zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly =
    new Wrapper(impl)
}
