package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  IPAddress,
  TransitGatewayArn,
  TransitGatewayAttachmentArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RouteAnalysisEndpointOptions(
    transitGatewayAttachmentArn: Optional[TransitGatewayAttachmentArn] =
      Optional.Absent,
    transitGatewayArn: Optional[TransitGatewayArn] = Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions = {
    import RouteAnalysisEndpointOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
      .builder()
      .optionallyWith(
        transitGatewayAttachmentArn.map(value =>
          TransitGatewayAttachmentArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentArn)
      .optionallyWith(
        transitGatewayArn.map(value =>
          TransitGatewayArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayArn)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisEndpointOptions
      .wrap(buildAwsValue())
}
object RouteAnalysisEndpointOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisEndpointOptions =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions(
        transitGatewayAttachmentArn.map(value => value),
        transitGatewayArn.map(value => value),
        ipAddress.map(value => value)
      )
    def transitGatewayAttachmentArn: Optional[TransitGatewayAttachmentArn]
    def transitGatewayArn: Optional[TransitGatewayArn]
    def ipAddress: Optional[IPAddress]
    def getTransitGatewayAttachmentArn
        : ZIO[Any, AwsError, TransitGatewayAttachmentArn] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentArn",
        transitGatewayAttachmentArn
      )
    def getTransitGatewayArn: ZIO[Any, AwsError, TransitGatewayArn] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ) extends zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly {
    override val transitGatewayAttachmentArn
        : Optional[TransitGatewayAttachmentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayAttachmentArn(value)
      )
    override val transitGatewayArn: Optional[TransitGatewayArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.TransitGatewayArn(value)
        )
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ): zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly =
    new Wrapper(impl)
}
