package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait RouteAnalysisCompletionReasonCode {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode
}
object RouteAnalysisCompletionReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode
  ): zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode =
    value match {
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND =>
        val r = TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY =>
        val r = TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.CYCLIC_PATH_DETECTED =>
        val r = CYCLIC_PATH_DETECTED
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND =>
        val r = TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.ROUTE_NOT_FOUND =>
        val r = ROUTE_NOT_FOUND
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND =>
        val r = BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.INACTIVE_ROUTE_FOR_DESTINATION_FOUND =>
        val r = INACTIVE_ROUTE_FOR_DESTINATION_FOUND
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH =>
        val r = TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.MAX_HOPS_EXCEEDED =>
        val r = MAX_HOPS_EXCEEDED
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.POSSIBLE_MIDDLEBOX =>
        val r = POSSIBLE_MIDDLEBOX
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.NO_DESTINATION_ARN_PROVIDED =>
        val r = NO_DESTINATION_ARN_PROVIDED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_NOT_FOUND
  }
  case object TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_NOT_IN_TRANSIT_GATEWAY
  }
  case object CYCLIC_PATH_DETECTED
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.CYCLIC_PATH_DETECTED
  }
  case object TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_STABLE_ROUTE_TABLE_NOT_FOUND
  }
  case object ROUTE_NOT_FOUND
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.ROUTE_NOT_FOUND
  }
  case object BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND
  }
  case object INACTIVE_ROUTE_FOR_DESTINATION_FOUND
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.INACTIVE_ROUTE_FOR_DESTINATION_FOUND
  }
  case object TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.TRANSIT_GATEWAY_ATTACHMENT_ATTACH_ARN_NO_MATCH
  }
  case object MAX_HOPS_EXCEEDED
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.MAX_HOPS_EXCEEDED
  }
  case object POSSIBLE_MIDDLEBOX
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.POSSIBLE_MIDDLEBOX
  }
  case object NO_DESTINATION_ARN_PROVIDED
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode.NO_DESTINATION_ARN_PROVIDED
  }
}
