package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  Integer,
  ClientToken,
  CoreNetworkPolicyDocument,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutCoreNetworkPolicyRequest(
    coreNetworkId: CoreNetworkId,
    policyDocument: CoreNetworkPolicyDocument,
    description: Optional[ConstrainedString] = Optional.Absent,
    latestVersionId: Optional[Integer] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest = {
    import PutCoreNetworkPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .policyDocument(
        CoreNetworkPolicyDocument.unwrap(policyDocument): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(latestVersionId.map(value => value: java.lang.Integer))(
        _.latestVersionId
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest.ReadOnly =
    zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest
      .wrap(buildAwsValue())
}
object PutCoreNetworkPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest =
      zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest(
        coreNetworkId,
        policyDocument,
        description.map(value => value),
        latestVersionId.map(value => value),
        clientToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def policyDocument: CoreNetworkPolicyDocument
    def description: Optional[ConstrainedString]
    def latestVersionId: Optional[Integer]
    def clientToken: Optional[ClientToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyDocument: ZIO[Any, Nothing, CoreNetworkPolicyDocument] =
      ZIO.succeed(policyDocument)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getLatestVersionId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("latestVersionId", latestVersionId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest
  ) extends zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyDocument: CoreNetworkPolicyDocument =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkPolicyDocument(impl.policyDocument())
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val latestVersionId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.latestVersionId())
      .map(value => value: Integer)
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest
  ): zio.aws.networkmanager.model.PutCoreNetworkPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
