package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{DateTime, ResourceArn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetNetworkRoutesResponse(
    routeTableArn: Optional[ResourceArn] = Optional.Absent,
    coreNetworkSegmentEdge: Optional[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
    ] = Optional.Absent,
    routeTableType: Optional[zio.aws.networkmanager.model.RouteTableType] =
      Optional.Absent,
    routeTableTimestamp: Optional[DateTime] = Optional.Absent,
    networkRoutes: Optional[
      Iterable[zio.aws.networkmanager.model.NetworkRoute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse = {
    import GetNetworkRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
      .builder()
      .optionallyWith(
        routeTableArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.routeTableArn)
      .optionallyWith(
        coreNetworkSegmentEdge.map(value => value.buildAwsValue())
      )(_.coreNetworkSegmentEdge)
      .optionallyWith(routeTableType.map(value => value.unwrap))(
        _.routeTableType
      )
      .optionallyWith(
        routeTableTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.routeTableTimestamp)
      .optionallyWith(
        networkRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkRoutes)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkRoutesResponse.wrap(buildAwsValue())
}
object GetNetworkRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetNetworkRoutesResponse =
      zio.aws.networkmanager.model.GetNetworkRoutesResponse(
        routeTableArn.map(value => value),
        coreNetworkSegmentEdge.map(value => value.asEditable),
        routeTableType.map(value => value),
        routeTableTimestamp.map(value => value),
        networkRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def routeTableArn: Optional[ResourceArn]
    def coreNetworkSegmentEdge: Optional[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ]
    def routeTableType: Optional[zio.aws.networkmanager.model.RouteTableType]
    def routeTableTimestamp: Optional[DateTime]
    def networkRoutes
        : Optional[List[zio.aws.networkmanager.model.NetworkRoute.ReadOnly]]
    def getRouteTableArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("routeTableArn", routeTableArn)
    def getCoreNetworkSegmentEdge: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "coreNetworkSegmentEdge",
      coreNetworkSegmentEdge
    )
    def getRouteTableType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteTableType] =
      AwsError.unwrapOptionField("routeTableType", routeTableType)
    def getRouteTableTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("routeTableTimestamp", routeTableTimestamp)
    def getNetworkRoutes: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("networkRoutes", networkRoutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ) extends zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly {
    override val routeTableArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val coreNetworkSegmentEdge: Optional[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkSegmentEdge())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
          .wrap(value)
      )
    override val routeTableType
        : Optional[zio.aws.networkmanager.model.RouteTableType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableType())
        .map(value => zio.aws.networkmanager.model.RouteTableType.wrap(value))
    override val routeTableTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableTimestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val networkRoutes
        : Optional[List[zio.aws.networkmanager.model.NetworkRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.NetworkRoute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ): zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
