package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.PeeringId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTransitGatewayPeeringRequest(peeringId: PeeringId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest = {
    import GetTransitGatewayPeeringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest
      .builder()
      .peeringId(PeeringId.unwrap(peeringId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayPeeringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest =
      zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest(peeringId)
    def peeringId: PeeringId
    def getPeeringId: ZIO[Any, Nothing, PeeringId] = ZIO.succeed(peeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest
  ) extends zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest.ReadOnly {
    override val peeringId: PeeringId =
      zio.aws.networkmanager.model.primitives.PeeringId(impl.peeringId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringRequest
  ): zio.aws.networkmanager.model.GetTransitGatewayPeeringRequest.ReadOnly =
    new Wrapper(impl)
}
