package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRouteAnalysisRequest(
    globalNetworkId: GlobalNetworkId,
    routeAnalysisId: ConstrainedString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest = {
    import GetRouteAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .routeAnalysisId(
        ConstrainedString.unwrap(routeAnalysisId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetRouteAnalysisRequest.ReadOnly =
    zio.aws.networkmanager.model.GetRouteAnalysisRequest.wrap(buildAwsValue())
}
object GetRouteAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetRouteAnalysisRequest =
      zio.aws.networkmanager.model
        .GetRouteAnalysisRequest(globalNetworkId, routeAnalysisId)
    def globalNetworkId: GlobalNetworkId
    def routeAnalysisId: ConstrainedString
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getRouteAnalysisId: ZIO[Any, Nothing, ConstrainedString] =
      ZIO.succeed(routeAnalysisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest
  ) extends zio.aws.networkmanager.model.GetRouteAnalysisRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val routeAnalysisId: ConstrainedString =
      zio.aws.networkmanager.model.primitives
        .ConstrainedString(impl.routeAnalysisId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest
  ): zio.aws.networkmanager.model.GetRouteAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
