package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCoreNetworkResponse(
    coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse = {
    import GetCoreNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse
      .builder()
      .optionallyWith(coreNetwork.map(value => value.buildAwsValue()))(
        _.coreNetwork
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkResponse.wrap(buildAwsValue())
}
object GetCoreNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetCoreNetworkResponse =
      zio.aws.networkmanager.model
        .GetCoreNetworkResponse(coreNetwork.map(value => value.asEditable))
    def coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly]
    def getCoreNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetwork", coreNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse
  ) extends zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly {
    override val coreNetwork
        : Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetwork())
        .map(value => zio.aws.networkmanager.model.CoreNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkResponse
  ): zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly = new Wrapper(
    impl
  )
}
