package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConnectAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest = {
    import GetConnectAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetConnectAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.GetConnectAttachmentRequest
      .wrap(buildAwsValue())
}
object GetConnectAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectAttachmentRequest =
      zio.aws.networkmanager.model.GetConnectAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest
  ) extends zio.aws.networkmanager.model.GetConnectAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest
  ): zio.aws.networkmanager.model.GetConnectAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
