package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.GlobalNetworkId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalNetworkRequest(globalNetworkId: GlobalNetworkId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest = {
    import DeleteGlobalNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteGlobalNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteGlobalNetworkRequest
      .wrap(buildAwsValue())
}
object DeleteGlobalNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteGlobalNetworkRequest =
      zio.aws.networkmanager.model.DeleteGlobalNetworkRequest(globalNetworkId)
    def globalNetworkId: GlobalNetworkId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest
  ) extends zio.aws.networkmanager.model.DeleteGlobalNetworkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest
  ): zio.aws.networkmanager.model.DeleteGlobalNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
