package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGlobalNetworkResponse(
    globalNetwork: Optional[zio.aws.networkmanager.model.GlobalNetwork] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse = {
    import CreateGlobalNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
      .builder()
      .optionallyWith(globalNetwork.map(value => value.buildAwsValue()))(
        _.globalNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateGlobalNetworkResponse
      .wrap(buildAwsValue())
}
object CreateGlobalNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateGlobalNetworkResponse =
      zio.aws.networkmanager.model.CreateGlobalNetworkResponse(
        globalNetwork.map(value => value.asEditable)
      )
    def globalNetwork
        : Optional[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
    def getGlobalNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("globalNetwork", globalNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ) extends zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly {
    override val globalNetwork
        : Optional[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetwork())
        .map(value => zio.aws.networkmanager.model.GlobalNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse
  ): zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
