package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait TransitGatewayConnectPeerAssociationState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState
}
object TransitGatewayConnectPeerAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState
  ): zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState =
    value match {
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.PENDING =>
        val r = PENDING
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.AVAILABLE =>
        val r = AVAILABLE
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.DELETING =>
        val r = DELETING
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.DELETED =>
        val r = DELETED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.PENDING
  }
  case object AVAILABLE
      extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.AVAILABLE
  }
  case object DELETING
      extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.DELETING
  }
  case object DELETED
      extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState.DELETED
  }
}
