package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.networkmanager.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.TagResourceRequest.ReadOnly =
    zio.aws.networkmanager.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.TagResourceRequest =
      zio.aws.networkmanager.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.networkmanager.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TagResourceRequest
  ) extends zio.aws.networkmanager.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkmanager.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.networkmanager.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.networkmanager.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TagResourceRequest
  ): zio.aws.networkmanager.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
