package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.CoreNetworkId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCoreNetworkRequest(coreNetworkId: CoreNetworkId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest = {
    import DeleteCoreNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteCoreNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteCoreNetworkRequest.wrap(buildAwsValue())
}
object DeleteCoreNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteCoreNetworkRequest =
      zio.aws.networkmanager.model.DeleteCoreNetworkRequest(coreNetworkId)
    def coreNetworkId: CoreNetworkId
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest
  ) extends zio.aws.networkmanager.model.DeleteCoreNetworkRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest
  ): zio.aws.networkmanager.model.DeleteCoreNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
