package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId,
  CustomerGatewayArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomerGatewayAssociation(
    customerGatewayArn: Optional[CustomerGatewayArn] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    linkId: Optional[LinkId] = Optional.Absent,
    state: Optional[
      zio.aws.networkmanager.model.CustomerGatewayAssociationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation = {
    import CustomerGatewayAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
      .builder()
      .optionallyWith(
        customerGatewayArn.map(value =>
          CustomerGatewayArn.unwrap(value): java.lang.String
        )
      )(_.customerGatewayArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly =
    zio.aws.networkmanager.model.CustomerGatewayAssociation
      .wrap(buildAwsValue())
}
object CustomerGatewayAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CustomerGatewayAssociation =
      zio.aws.networkmanager.model.CustomerGatewayAssociation(
        customerGatewayArn.map(value => value),
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        state.map(value => value)
      )
    def customerGatewayArn: Optional[CustomerGatewayArn]
    def globalNetworkId: Optional[GlobalNetworkId]
    def deviceId: Optional[DeviceId]
    def linkId: Optional[LinkId]
    def state
        : Optional[zio.aws.networkmanager.model.CustomerGatewayAssociationState]
    def getCustomerGatewayArn: ZIO[Any, AwsError, CustomerGatewayArn] =
      AwsError.unwrapOptionField("customerGatewayArn", customerGatewayArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CustomerGatewayAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ) extends zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly {
    override val customerGatewayArn: Optional[CustomerGatewayArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGatewayArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.CustomerGatewayArn(value)
        )
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val state: Optional[
      zio.aws.networkmanager.model.CustomerGatewayAssociationState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.networkmanager.model.CustomerGatewayAssociationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ): zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly =
    new Wrapper(impl)
}
