package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSiteRequest(
    globalNetworkId: GlobalNetworkId,
    description: Optional[ConstrainedString] = Optional.Absent,
    location: Optional[zio.aws.networkmanager.model.Location] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest = {
    import CreateSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateSiteRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateSiteRequest.wrap(buildAwsValue())
}
object CreateSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateSiteRequest =
      zio.aws.networkmanager.model.CreateSiteRequest(
        globalNetworkId,
        description.map(value => value),
        location.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: GlobalNetworkId
    def description: Optional[ConstrainedString]
    def location: Optional[zio.aws.networkmanager.model.Location.ReadOnly]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest
  ) extends zio.aws.networkmanager.model.CreateSiteRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val location
        : Optional[zio.aws.networkmanager.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest
  ): zio.aws.networkmanager.model.CreateSiteRequest.ReadOnly = new Wrapper(impl)
}
