package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ResourcePolicyDocument
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyResponse(
    policyDocument: Optional[ResourcePolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        policyDocument.map(value =>
          ResourcePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.networkmanager.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetResourcePolicyResponse =
      zio.aws.networkmanager.model
        .GetResourcePolicyResponse(policyDocument.map(value => value))
    def policyDocument: Optional[ResourcePolicyDocument]
    def getPolicyDocument: ZIO[Any, AwsError, ResourcePolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse
  ) extends zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly {
    override val policyDocument: Optional[ResourcePolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ResourcePolicyDocument(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyResponse
  ): zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
