package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  Integer,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCoreNetworkChangeEventsRequest(
    coreNetworkId: CoreNetworkId,
    policyVersionId: Integer,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest = {
    import GetCoreNetworkChangeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .policyVersionId(policyVersionId: java.lang.Integer)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest
      .wrap(buildAwsValue())
}
object GetCoreNetworkChangeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest =
      zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest(
        coreNetworkId,
        policyVersionId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def policyVersionId: Integer
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyVersionId: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(policyVersionId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
  ) extends zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyVersionId: Integer = impl.policyVersionId(): Integer
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
  ): zio.aws.networkmanager.model.GetCoreNetworkChangeEventsRequest.ReadOnly =
    new Wrapper(impl)
}
