package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  AttachmentId,
  ExternalRegionCode,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConnectAttachmentRequest(
    coreNetworkId: CoreNetworkId,
    edgeLocation: ExternalRegionCode,
    transportAttachmentId: AttachmentId,
    options: zio.aws.networkmanager.model.ConnectAttachmentOptions,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest = {
    import CreateConnectAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .edgeLocation(ExternalRegionCode.unwrap(edgeLocation): java.lang.String)
      .transportAttachmentId(
        AttachmentId.unwrap(transportAttachmentId): java.lang.String
      )
      .options(options.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateConnectAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateConnectAttachmentRequest =
      zio.aws.networkmanager.model.CreateConnectAttachmentRequest(
        coreNetworkId,
        edgeLocation,
        transportAttachmentId,
        options.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def edgeLocation: ExternalRegionCode
    def transportAttachmentId: AttachmentId
    def options: zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getEdgeLocation: ZIO[Any, Nothing, ExternalRegionCode] =
      ZIO.succeed(edgeLocation)
    def getTransportAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(transportAttachmentId)
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest
  ) extends zio.aws.networkmanager.model.CreateConnectAttachmentRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val edgeLocation: ExternalRegionCode =
      zio.aws.networkmanager.model.primitives
        .ExternalRegionCode(impl.edgeLocation())
    override val transportAttachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives
        .AttachmentId(impl.transportAttachmentId())
    override val options
        : zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly =
      zio.aws.networkmanager.model.ConnectAttachmentOptions.wrap(impl.options())
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest
  ): zio.aws.networkmanager.model.CreateConnectAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
