package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId,
  CustomerGatewayArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateCustomerGatewayRequest(
    customerGatewayArn: CustomerGatewayArn,
    globalNetworkId: GlobalNetworkId,
    deviceId: DeviceId,
    linkId: Optional[LinkId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest = {
    import AssociateCustomerGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest
      .builder()
      .customerGatewayArn(
        CustomerGatewayArn.unwrap(customerGatewayArn): java.lang.String
      )
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AssociateCustomerGatewayRequest.ReadOnly =
    zio.aws.networkmanager.model.AssociateCustomerGatewayRequest
      .wrap(buildAwsValue())
}
object AssociateCustomerGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.AssociateCustomerGatewayRequest =
      zio.aws.networkmanager.model.AssociateCustomerGatewayRequest(
        customerGatewayArn,
        globalNetworkId,
        deviceId,
        linkId.map(value => value)
      )
    def customerGatewayArn: CustomerGatewayArn
    def globalNetworkId: GlobalNetworkId
    def deviceId: DeviceId
    def linkId: Optional[LinkId]
    def getCustomerGatewayArn: ZIO[Any, Nothing, CustomerGatewayArn] =
      ZIO.succeed(customerGatewayArn)
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest
  ) extends zio.aws.networkmanager.model.AssociateCustomerGatewayRequest.ReadOnly {
    override val customerGatewayArn: CustomerGatewayArn =
      zio.aws.networkmanager.model.primitives
        .CustomerGatewayArn(impl.customerGatewayArn())
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest
  ): zio.aws.networkmanager.model.AssociateCustomerGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
