package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait RouteType {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.RouteType
}
object RouteType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteType
  ): zio.aws.networkmanager.model.RouteType = value match {
    case software.amazon.awssdk.services.networkmanager.model.RouteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteType.PROPAGATED =>
      val r = PROPAGATED
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteType.STATIC =>
      val r = STATIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteType =
      software.amazon.awssdk.services.networkmanager.model.RouteType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROPAGATED extends zio.aws.networkmanager.model.RouteType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteType =
      software.amazon.awssdk.services.networkmanager.model.RouteType.PROPAGATED
  }
  case object STATIC extends zio.aws.networkmanager.model.RouteType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteType =
      software.amazon.awssdk.services.networkmanager.model.RouteType.STATIC
  }
}
