package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSitesResponse(
    sites: Optional[Iterable[zio.aws.networkmanager.model.Site]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetSitesResponse = {
    import GetSitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
      .builder()
      .optionallyWith(
        sites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sites)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetSitesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetSitesResponse.wrap(buildAwsValue())
}
object GetSitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetSitesResponse =
      zio.aws.networkmanager.model.GetSitesResponse(
        sites.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sites: Optional[List[zio.aws.networkmanager.model.Site.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSites
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Site.ReadOnly]] =
      AwsError.unwrapOptionField("sites", sites)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ) extends zio.aws.networkmanager.model.GetSitesResponse.ReadOnly {
    override val sites
        : Optional[List[zio.aws.networkmanager.model.Site.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Site.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ): zio.aws.networkmanager.model.GetSitesResponse.ReadOnly = new Wrapper(impl)
}
