package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalNetworkResponse(
    globalNetwork: Optional[zio.aws.networkmanager.model.GlobalNetwork] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse = {
    import DeleteGlobalNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
      .builder()
      .optionallyWith(globalNetwork.map(value => value.buildAwsValue()))(
        _.globalNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteGlobalNetworkResponse
      .wrap(buildAwsValue())
}
object DeleteGlobalNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteGlobalNetworkResponse =
      zio.aws.networkmanager.model.DeleteGlobalNetworkResponse(
        globalNetwork.map(value => value.asEditable)
      )
    def globalNetwork
        : Optional[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
    def getGlobalNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("globalNetwork", globalNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ) extends zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly {
    override val globalNetwork
        : Optional[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetwork())
        .map(value => zio.aws.networkmanager.model.GlobalNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse
  ): zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
