package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  SiteId,
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDeviceRequest(
    globalNetworkId: GlobalNetworkId,
    awsLocation: Optional[zio.aws.networkmanager.model.AWSLocation] =
      Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    `type`: Optional[ConstrainedString] = Optional.Absent,
    vendor: Optional[ConstrainedString] = Optional.Absent,
    model: Optional[ConstrainedString] = Optional.Absent,
    serialNumber: Optional[ConstrainedString] = Optional.Absent,
    location: Optional[zio.aws.networkmanager.model.Location] = Optional.Absent,
    siteId: Optional[SiteId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest = {
    import CreateDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(awsLocation.map(value => value.buildAwsValue()))(
        _.awsLocation
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vendor.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        model.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        serialNumber.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateDeviceRequest.wrap(buildAwsValue())
}
object CreateDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateDeviceRequest =
      zio.aws.networkmanager.model.CreateDeviceRequest(
        globalNetworkId,
        awsLocation.map(value => value.asEditable),
        description.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value),
        model.map(value => value),
        serialNumber.map(value => value),
        location.map(value => value.asEditable),
        siteId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: GlobalNetworkId
    def awsLocation: Optional[zio.aws.networkmanager.model.AWSLocation.ReadOnly]
    def description: Optional[ConstrainedString]
    def `type`: Optional[ConstrainedString]
    def vendor: Optional[ConstrainedString]
    def model: Optional[ConstrainedString]
    def serialNumber: Optional[ConstrainedString]
    def location: Optional[zio.aws.networkmanager.model.Location.ReadOnly]
    def siteId: Optional[SiteId]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getAwsLocation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.AWSLocation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLocation", awsLocation)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getModel: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("model", model)
    def getSerialNumber: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ) extends zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val awsLocation
        : Optional[zio.aws.networkmanager.model.AWSLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLocation())
        .map(value => zio.aws.networkmanager.model.AWSLocation.wrap(value))
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val `type`: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val vendor: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val model: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val serialNumber: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val location
        : Optional[zio.aws.networkmanager.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val siteId: Optional[SiteId] = zio.aws.core.internal
      .optionalFromNullable(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ): zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
