package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConnectAttachmentResponse(
    connectAttachment: Optional[
      zio.aws.networkmanager.model.ConnectAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse = {
    import CreateConnectAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
      .builder()
      .optionallyWith(connectAttachment.map(value => value.buildAwsValue()))(
        _.connectAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateConnectAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateConnectAttachmentResponse =
      zio.aws.networkmanager.model.CreateConnectAttachmentResponse(
        connectAttachment.map(value => value.asEditable)
      )
    def connectAttachment
        : Optional[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly]
    def getConnectAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("connectAttachment", connectAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ) extends zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly {
    override val connectAttachment
        : Optional[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectAttachment())
        .map(value =>
          zio.aws.networkmanager.model.ConnectAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ): zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
