package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  DeviceId,
  ConnectionId,
  LinkId,
  DateTime,
  ConnectionArn
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Connection(
    connectionId: Optional[ConnectionId] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    connectedDeviceId: Optional[DeviceId] = Optional.Absent,
    linkId: Optional[LinkId] = Optional.Absent,
    connectedLinkId: Optional[LinkId] = Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.ConnectionState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Connection = {
    import Connection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Connection
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        connectedDeviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.connectedDeviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(
        connectedLinkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.connectedLinkId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Connection.ReadOnly =
    zio.aws.networkmanager.model.Connection.wrap(buildAwsValue())
}
object Connection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Connection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Connection =
      zio.aws.networkmanager.model.Connection(
        connectionId.map(value => value),
        connectionArn.map(value => value),
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        connectedDeviceId.map(value => value),
        linkId.map(value => value),
        connectedLinkId.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionId: Optional[ConnectionId]
    def connectionArn: Optional[ConnectionArn]
    def globalNetworkId: Optional[GlobalNetworkId]
    def deviceId: Optional[DeviceId]
    def connectedDeviceId: Optional[DeviceId]
    def linkId: Optional[LinkId]
    def connectedLinkId: Optional[LinkId]
    def description: Optional[ConstrainedString]
    def createdAt: Optional[DateTime]
    def state: Optional[zio.aws.networkmanager.model.ConnectionState]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getConnectedDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("connectedDeviceId", connectedDeviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getConnectedLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("connectedLinkId", connectedLinkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ConnectionState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Connection
  ) extends zio.aws.networkmanager.model.Connection.ReadOnly {
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.networkmanager.model.primitives.ConnectionId(value))
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConnectionArn(value)
      )
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val connectedDeviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedDeviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val connectedLinkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedLinkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.networkmanager.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.ConnectionState.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Connection
  ): zio.aws.networkmanager.model.Connection.ReadOnly = new Wrapper(impl)
}
