package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateCustomerGatewayResponse(
    customerGatewayAssociation: Optional[
      zio.aws.networkmanager.model.CustomerGatewayAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse = {
    import AssociateCustomerGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse
      .builder()
      .optionallyWith(
        customerGatewayAssociation.map(value => value.buildAwsValue())
      )(_.customerGatewayAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly =
    zio.aws.networkmanager.model.AssociateCustomerGatewayResponse
      .wrap(buildAwsValue())
}
object AssociateCustomerGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.AssociateCustomerGatewayResponse =
      zio.aws.networkmanager.model.AssociateCustomerGatewayResponse(
        customerGatewayAssociation.map(value => value.asEditable)
      )
    def customerGatewayAssociation: Optional[
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ]
    def getCustomerGatewayAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customerGatewayAssociation",
      customerGatewayAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse
  ) extends zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly {
    override val customerGatewayAssociation: Optional[
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerGatewayAssociation())
      .map(value =>
        zio.aws.networkmanager.model.CustomerGatewayAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse
  ): zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
