package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait RouteAnalysisStatus {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus
}
object RouteAnalysisStatus {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus
  ): zio.aws.networkmanager.model.RouteAnalysisStatus = value match {
    case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteAnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.networkmanager.model.RouteAnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.RUNNING
  }
  case object COMPLETED
      extends zio.aws.networkmanager.model.RouteAnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.COMPLETED
  }
  case object FAILED extends zio.aws.networkmanager.model.RouteAnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus.FAILED
  }
}
