package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTransitGatewayConnectPeerAssociationsResponse(
    transitGatewayConnectPeerAssociations: Optional[Iterable[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse = {
    import GetTransitGatewayConnectPeerAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
      .builder()
      .optionallyWith(
        transitGatewayConnectPeerAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayConnectPeerAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayConnectPeerAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse =
      zio.aws.networkmanager.model
        .GetTransitGatewayConnectPeerAssociationsResponse(
          transitGatewayConnectPeerAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def transitGatewayConnectPeerAssociations: Optional[List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getTransitGatewayConnectPeerAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayConnectPeerAssociations",
      transitGatewayConnectPeerAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly {
    override val transitGatewayConnectPeerAssociations: Optional[List[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConnectPeerAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
  ): zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
