package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  TransitGatewayRouteTableArn,
  PeeringId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTransitGatewayRouteTableAttachmentRequest(
    peeringId: PeeringId,
    transitGatewayRouteTableArn: TransitGatewayRouteTableArn,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest = {
    import CreateTransitGatewayRouteTableAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
      .builder()
      .peeringId(PeeringId.unwrap(peeringId): java.lang.String)
      .transitGatewayRouteTableArn(
        TransitGatewayRouteTableArn.unwrap(
          transitGatewayRouteTableArn
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayRouteTableAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest =
      zio.aws.networkmanager.model
        .CreateTransitGatewayRouteTableAttachmentRequest(
          peeringId,
          transitGatewayRouteTableArn,
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          clientToken.map(value => value)
        )
    def peeringId: PeeringId
    def transitGatewayRouteTableArn: TransitGatewayRouteTableArn
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getPeeringId: ZIO[Any, Nothing, PeeringId] = ZIO.succeed(peeringId)
    def getTransitGatewayRouteTableArn
        : ZIO[Any, Nothing, TransitGatewayRouteTableArn] =
      ZIO.succeed(transitGatewayRouteTableArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
  ) extends zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest.ReadOnly {
    override val peeringId: PeeringId =
      zio.aws.networkmanager.model.primitives.PeeringId(impl.peeringId())
    override val transitGatewayRouteTableArn: TransitGatewayRouteTableArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayRouteTableArn(impl.transitGatewayRouteTableArn())
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
  ): zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
