package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateCoreNetworkRequest(
    coreNetworkId: CoreNetworkId,
    description: Optional[ConstrainedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest = {
    import UpdateCoreNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateCoreNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateCoreNetworkRequest.wrap(buildAwsValue())
}
object UpdateCoreNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateCoreNetworkRequest =
      zio.aws.networkmanager.model.UpdateCoreNetworkRequest(
        coreNetworkId,
        description.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def description: Optional[ConstrainedString]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest
  ) extends zio.aws.networkmanager.model.UpdateCoreNetworkRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest
  ): zio.aws.networkmanager.model.UpdateCoreNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
