package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPeeringsResponse(
    peerings: Optional[Iterable[zio.aws.networkmanager.model.Peering]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse = {
    import ListPeeringsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse
      .builder()
      .optionallyWith(
        peerings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.peerings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ListPeeringsResponse.ReadOnly =
    zio.aws.networkmanager.model.ListPeeringsResponse.wrap(buildAwsValue())
}
object ListPeeringsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListPeeringsResponse =
      zio.aws.networkmanager.model.ListPeeringsResponse(
        peerings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def peerings: Optional[List[zio.aws.networkmanager.model.Peering.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPeerings: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.Peering.ReadOnly
    ]] = AwsError.unwrapOptionField("peerings", peerings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse
  ) extends zio.aws.networkmanager.model.ListPeeringsResponse.ReadOnly {
    override val peerings
        : Optional[List[zio.aws.networkmanager.model.Peering.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peerings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Peering.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse
  ): zio.aws.networkmanager.model.ListPeeringsResponse.ReadOnly = new Wrapper(
    impl
  )
}
