package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  GlobalNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeGlobalNetworksRequest(
    globalNetworkIds: Optional[Iterable[GlobalNetworkId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest = {
    import DescribeGlobalNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
      .builder()
      .optionallyWith(
        globalNetworkIds.map(value =>
          value.map { item =>
            GlobalNetworkId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.globalNetworkIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly =
    zio.aws.networkmanager.model.DescribeGlobalNetworksRequest
      .wrap(buildAwsValue())
}
object DescribeGlobalNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DescribeGlobalNetworksRequest =
      zio.aws.networkmanager.model.DescribeGlobalNetworksRequest(
        globalNetworkIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkIds: Optional[List[GlobalNetworkId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkIds: ZIO[Any, AwsError, List[GlobalNetworkId]] =
      AwsError.unwrapOptionField("globalNetworkIds", globalNetworkIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ) extends zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly {
    override val globalNetworkIds: Optional[List[GlobalNetworkId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.GlobalNetworkId(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ): zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly =
    new Wrapper(impl)
}
