package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGlobalNetworkRequest(
    description: Optional[ConstrainedString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest = {
    import CreateGlobalNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateGlobalNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateGlobalNetworkRequest
      .wrap(buildAwsValue())
}
object CreateGlobalNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateGlobalNetworkRequest =
      zio.aws.networkmanager.model.CreateGlobalNetworkRequest(
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[ConstrainedString]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest
  ) extends zio.aws.networkmanager.model.CreateGlobalNetworkRequest.ReadOnly {
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest
  ): zio.aws.networkmanager.model.CreateGlobalNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
