package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait CoreNetworkState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState
}
object CoreNetworkState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.CoreNetworkState
  ): zio.aws.networkmanager.model.CoreNetworkState = value match {
    case software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.CoreNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState =
      software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.networkmanager.model.CoreNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState =
      software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.CREATING
  }
  case object UPDATING extends zio.aws.networkmanager.model.CoreNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState =
      software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.UPDATING
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.CoreNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState =
      software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.CoreNetworkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.CoreNetworkState =
      software.amazon.awssdk.services.networkmanager.model.CoreNetworkState.DELETING
  }
}
