package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ChangeType
  ): zio.aws.networkmanager.model.ChangeType = value match {
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_SEGMENT =>
      val r = CORE_NETWORK_SEGMENT
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_EDGE =>
      val r = CORE_NETWORK_EDGE
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_MAPPING =>
      val r = ATTACHMENT_MAPPING
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_ROUTE_PROPAGATION =>
      val r = ATTACHMENT_ROUTE_PROPAGATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_ROUTE_STATIC =>
      val r = ATTACHMENT_ROUTE_STATIC
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_CONFIGURATION =>
      val r = CORE_NETWORK_CONFIGURATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.SEGMENTS_CONFIGURATION =>
      val r = SEGMENTS_CONFIGURATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.SEGMENT_ACTIONS_CONFIGURATION =>
      val r = SEGMENT_ACTIONS_CONFIGURATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_POLICIES_CONFIGURATION =>
      val r = ATTACHMENT_POLICIES_CONFIGURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object CORE_NETWORK_SEGMENT
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_SEGMENT
  }
  case object CORE_NETWORK_EDGE
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_EDGE
  }
  case object ATTACHMENT_MAPPING
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_MAPPING
  }
  case object ATTACHMENT_ROUTE_PROPAGATION
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_ROUTE_PROPAGATION
  }
  case object ATTACHMENT_ROUTE_STATIC
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_ROUTE_STATIC
  }
  case object CORE_NETWORK_CONFIGURATION
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.CORE_NETWORK_CONFIGURATION
  }
  case object SEGMENTS_CONFIGURATION
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.SEGMENTS_CONFIGURATION
  }
  case object SEGMENT_ACTIONS_CONFIGURATION
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.SEGMENT_ACTIONS_CONFIGURATION
  }
  case object ATTACHMENT_POLICIES_CONFIGURATION
      extends zio.aws.networkmanager.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeType =
      software.amazon.awssdk.services.networkmanager.model.ChangeType.ATTACHMENT_POLICIES_CONFIGURATION
  }
}
