package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{SubnetArn, AttachmentId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcAttachmentRequest(
    attachmentId: AttachmentId,
    addSubnetArns: Optional[Iterable[SubnetArn]] = Optional.Absent,
    removeSubnetArns: Optional[Iterable[SubnetArn]] = Optional.Absent,
    options: Optional[zio.aws.networkmanager.model.VpcOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest = {
    import UpdateVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .optionallyWith(
        addSubnetArns.map(value =>
          value.map { item =>
            SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetArns)
      .optionallyWith(
        removeSubnetArns.map(value =>
          value.map { item =>
            SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetArns)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateVpcAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object UpdateVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateVpcAttachmentRequest =
      zio.aws.networkmanager.model.UpdateVpcAttachmentRequest(
        attachmentId,
        addSubnetArns.map(value => value),
        removeSubnetArns.map(value => value),
        options.map(value => value.asEditable)
      )
    def attachmentId: AttachmentId
    def addSubnetArns: Optional[List[SubnetArn]]
    def removeSubnetArns: Optional[List[SubnetArn]]
    def options: Optional[zio.aws.networkmanager.model.VpcOptions.ReadOnly]
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
    def getAddSubnetArns: ZIO[Any, AwsError, List[SubnetArn]] =
      AwsError.unwrapOptionField("addSubnetArns", addSubnetArns)
    def getRemoveSubnetArns: ZIO[Any, AwsError, List[SubnetArn]] =
      AwsError.unwrapOptionField("removeSubnetArns", removeSubnetArns)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.VpcOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest
  ) extends zio.aws.networkmanager.model.UpdateVpcAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
    override val addSubnetArns: Optional[List[SubnetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addSubnetArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.SubnetArn(item)
          }.toList
        )
    override val removeSubnetArns: Optional[List[SubnetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSubnetArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.SubnetArn(item)
          }.toList
        )
    override val options
        : Optional[zio.aws.networkmanager.model.VpcOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.networkmanager.model.VpcOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest
  ): zio.aws.networkmanager.model.UpdateVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
