package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  ResourceArn,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkResourceMetadataRequest(
    globalNetworkId: GlobalNetworkId,
    resourceArn: ResourceArn,
    metadata: Map[ConstrainedString, ConstrainedString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest = {
    import UpdateNetworkResourceMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .metadata(
        metadata
          .map({ case (key, value) =>
            (ConstrainedString
              .unwrap(key): java.lang.String) -> (ConstrainedString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkResourceMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest =
      zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest(
        globalNetworkId,
        resourceArn,
        metadata
      )
    def globalNetworkId: GlobalNetworkId
    def resourceArn: ResourceArn
    def metadata: Map[ConstrainedString, ConstrainedString]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getMetadata
        : ZIO[Any, Nothing, Map[ConstrainedString, ConstrainedString]] =
      ZIO.succeed(metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
  ) extends zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val resourceArn: ResourceArn =
      zio.aws.networkmanager.model.primitives.ResourceArn(impl.resourceArn())
    override val metadata: Map[ConstrainedString, ConstrainedString] = impl
      .metadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(
          key
        ) -> zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
  ): zio.aws.networkmanager.model.UpdateNetworkResourceMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
