package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateConnectionResponse(
    connection: Optional[zio.aws.networkmanager.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse = {
    import UpdateConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateConnectionResponse.wrap(buildAwsValue())
}
object UpdateConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateConnectionResponse =
      zio.aws.networkmanager.model
        .UpdateConnectionResponse(connection.map(value => value.asEditable))
    def connection: Optional[zio.aws.networkmanager.model.Connection.ReadOnly]
    def getConnection
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Connection.ReadOnly] =
      AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ) extends zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.networkmanager.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.networkmanager.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ): zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
