package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkRoute(
    destinationCidrBlock: Optional[ConstrainedString] = Optional.Absent,
    destinations: Optional[
      Iterable[zio.aws.networkmanager.model.NetworkRouteDestination]
    ] = Optional.Absent,
    prefixListId: Optional[ConstrainedString] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.RouteState] = Optional.Absent,
    `type`: Optional[zio.aws.networkmanager.model.RouteType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkRoute = {
    import NetworkRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        prefixListId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkRoute.ReadOnly =
    zio.aws.networkmanager.model.NetworkRoute.wrap(buildAwsValue())
}
object NetworkRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkRoute =
      zio.aws.networkmanager.model.NetworkRoute(
        destinationCidrBlock.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListId.map(value => value),
        state.map(value => value),
        `type`.map(value => value)
      )
    def destinationCidrBlock: Optional[ConstrainedString]
    def destinations: Optional[
      List[zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly]
    ]
    def prefixListId: Optional[ConstrainedString]
    def state: Optional[zio.aws.networkmanager.model.RouteState]
    def `type`: Optional[zio.aws.networkmanager.model.RouteType]
    def getDestinationCidrBlock: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getPrefixListId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ) extends zio.aws.networkmanager.model.NetworkRoute.ReadOnly {
    override val destinationCidrBlock: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationCidrBlock())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val destinations: Optional[
      List[zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.NetworkRouteDestination.wrap(item)
        }.toList
      )
    override val prefixListId: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val state: Optional[zio.aws.networkmanager.model.RouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.RouteState.wrap(value))
    override val `type`: Optional[zio.aws.networkmanager.model.RouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkmanager.model.RouteType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ): zio.aws.networkmanager.model.NetworkRoute.ReadOnly = new Wrapper(impl)
}
