package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  AttachmentId,
  CoreNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListConnectPeersRequest(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    connectAttachmentId: Optional[AttachmentId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest = {
    import ListConnectPeersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        connectAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.connectAttachmentId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly =
    zio.aws.networkmanager.model.ListConnectPeersRequest.wrap(buildAwsValue())
}
object ListConnectPeersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListConnectPeersRequest =
      zio.aws.networkmanager.model.ListConnectPeersRequest(
        coreNetworkId.map(value => value),
        connectAttachmentId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def connectAttachmentId: Optional[AttachmentId]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getConnectAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("connectAttachmentId", connectAttachmentId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ) extends zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val connectAttachmentId: Optional[AttachmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectAttachmentId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.AttachmentId(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ): zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly =
    new Wrapper(impl)
}
